/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.api.util.UserContext;
import filenet.vw.api.VWException;
import filenet.vw.api.VWGuid;
import filenet.vw.base.CEObjectInfo;
import javax.security.auth.Subject;

public class ORBFetchCEObject {
    private String m_cempUri = null;
    private transient Subject m_ucSubject = null;

    public ORBFetchCEObject(String ceUrl, Subject subject) throws VWException {
        if (ceUrl == null || ceUrl.trim().length() == 0) {
            throw new VWException("vw.server.CEObjectRetriever.missingConnectionPoint", "Missing connection point information.");
        }
        this.m_cempUri = ceUrl;
        this.m_ucSubject = subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetchObjectStoreSymbolicName(VWGuid objectStoreId) throws VWException {
        UserContext old;
        block3: {
            String string;
            old = UserContext.get();
            try {
                UserContext uc = new UserContext();
                uc.pushSubject(this.m_ucSubject);
                UserContext.set((UserContext)uc);
                Connection myConnection = Factory.Connection.getConnection((String)this.m_cempUri);
                Domain myDomain = Factory.Domain.getInstance((Connection)myConnection, null);
                Id myObjectStoreId = new Id(objectStoreId.getBytes());
                ObjectStore os = Factory.ObjectStore.fetchInstance((Domain)myDomain, (Id)myObjectStoreId, (PropertyFilter)null);
                if (os == null) break block3;
                string = os.get_SymbolicName();
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                UserContext.set((UserContext)old);
                throw throwable;
            }
            UserContext.set((UserContext)old);
            return string;
        }
        Object var10_10 = null;
        UserContext.set((UserContext)old);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWGuid fetchObjectStoreId(String objectStoreSymbolicName) throws VWException {
        UserContext old;
        block3: {
            VWGuid vWGuid;
            old = UserContext.get();
            try {
                UserContext uc = new UserContext();
                uc.pushSubject(this.m_ucSubject);
                UserContext.set((UserContext)uc);
                Connection myConnection = Factory.Connection.getConnection((String)this.m_cempUri);
                Domain myDomain = Factory.Domain.getInstance((Connection)myConnection, null);
                ObjectStore os = Factory.ObjectStore.fetchInstance((Domain)myDomain, (String)objectStoreSymbolicName, (PropertyFilter)null);
                if (os == null) break block3;
                Id osId = os.get_ObjectStoreId();
                vWGuid = new VWGuid(osId.getBytes());
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                UserContext.set((UserContext)old);
                throw throwable;
            }
            UserContext.set((UserContext)old);
            return vWGuid;
        }
        Object var10_10 = null;
        UserContext.set((UserContext)old);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CEObjectInfo fetchCEObjectInfo(VWGuid objectStoreId, VWGuid classId, VWGuid objectId) throws VWException {
        CEObjectInfo cEObjectInfo;
        UserContext old = UserContext.get();
        try {
            UserContext uc = new UserContext();
            uc.pushSubject(this.m_ucSubject);
            UserContext.set((UserContext)uc);
            Connection myConnection = Factory.Connection.getConnection((String)this.m_cempUri);
            Domain myDomain = Factory.Domain.getInstance((Connection)myConnection, null);
            Id myObjectStoreId = new Id(objectStoreId.getBytes());
            ObjectStore os = Factory.ObjectStore.getInstance((Domain)myDomain, (Id)myObjectStoreId);
            Id myObjectId = new Id(objectId.getBytes());
            CEObjectInfo ceObjectInfo = null;
            if (classId == null) {
                ClassDefinition cd = Factory.ClassDefinition.fetchInstance((ObjectStore)os, (Id)myObjectId, (PropertyFilter)null);
                ceObjectInfo = this.populatePropertyTypes(objectId.toString(), cd);
            } else {
                Id myClassId = new Id(classId.toString());
                IndependentlyPersistableObject eo = (IndependentlyPersistableObject)os.fetchObject(myClassId.toString(), myObjectId, (PropertyFilter)null);
                ceObjectInfo = this.populatePropertyValues(objectId.toString(), (EngineObject)eo);
            }
            cEObjectInfo = ceObjectInfo;
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            UserContext.set((UserContext)old);
            throw throwable;
        }
        UserContext.set((UserContext)old);
        return cEObjectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CEObjectInfo fetchCEObjectInfoByName(VWGuid objectStoreId, String symbolicName) throws VWException {
        CEObjectInfo cEObjectInfo;
        UserContext old = UserContext.get();
        try {
            CEObjectInfo ceObjectInfo;
            UserContext uc = new UserContext();
            uc.pushSubject(this.m_ucSubject);
            UserContext.set((UserContext)uc);
            Connection myConnection = Factory.Connection.getConnection((String)this.m_cempUri);
            Domain myDomain = Factory.Domain.getInstance((Connection)myConnection, null);
            Id myObjectStoreId = new Id(objectStoreId.getBytes());
            ObjectStore os = Factory.ObjectStore.getInstance((Domain)myDomain, (Id)myObjectStoreId);
            ClassDefinition cd = Factory.ClassDefinition.fetchInstance((ObjectStore)os, (String)symbolicName, (PropertyFilter)null);
            cEObjectInfo = ceObjectInfo = this.populatePropertyTypes(null, cd);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            UserContext.set((UserContext)old);
            throw throwable;
        }
        UserContext.set((UserContext)old);
        return cEObjectInfo;
    }

    private CEObjectInfo populatePropertyTypes(String guid, ClassDefinition cd) throws VWException {
        if (cd == null) {
            return null;
        }
        if (guid == null) {
            guid = cd.get_Id().toString();
        }
        CEObjectInfo ceObjectInfo = new CEObjectInfo(guid, cd.get_DisplayName(), cd.get_SymbolicName());
        PropertyDefinitionList pSet = cd.get_PropertyDefinitions();
        for (PropertyDefinition pd : pSet) {
            ceObjectInfo.setPropertyType(pd.get_SymbolicName(), this.getFieldTypeFromCEType(pd.get_DataType()), pd.get_Cardinality() != Cardinality.SINGLE);
        }
        return ceObjectInfo;
    }

    private int getFieldTypeFromCEType(TypeID ceType) {
        switch (ceType.getValue()) {
            case 2: {
                return 4;
            }
            case 8: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 6: {
                return 1;
            }
        }
        return -1;
    }

    private CEObjectInfo populatePropertyValues(String guid, EngineObject eo) throws VWException {
        if (eo == null) {
            return null;
        }
        CEObjectInfo ceObjectInfo = new CEObjectInfo(guid, eo.getClassName(), eo.getClassName());
        Properties ps = eo.getProperties();
        for (Property p : ps) {
            ceObjectInfo.setPropertyValue(p.getPropertyName(), p.getObjectValue());
        }
        return ceObjectInfo;
    }
}

